<?php
    /**
     * Class For Builder
     */
    class TechbizBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'techbiz_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'techbiz-core',TECHBIZ_PLUGDIRURI.'assets/js/techbiz-core.js',array( 'jquery' ),'1.0',true );
		}


        public function techbiz_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'techbiz_header_option',
                [
                    'label'     => __( 'Header Option', 'techbiz' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );

            $page->add_control(
                'techbiz_header_style',
                [
                    'label'     => __( 'Header Option', 'techbiz' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'techbiz' ),
    					'header_builder'       => __( 'Header Builder', 'techbiz' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'techbiz_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'techbiz' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->techbiz_header_choose_option(),
                    'condition' => [ 'techbiz_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'techbiz_footer_option',
                [
                    'label'     => __( 'Footer Option', 'techbiz' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'techbiz_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'techbiz' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'techbiz' ),
    				'label_off'     => __( 'No', 'techbiz' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'techbiz_footer_style',
                [
                    'label'     => __( 'Footer Style', 'techbiz' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'techbiz' ),
    					'footer_builder'       => __( 'Footer Builder', 'techbiz' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'techbiz_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'techbiz_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'techbiz' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->techbiz_footer_choose_option(),
                    'condition' => [ 'techbiz_footer_style' => 'footer_builder','techbiz_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Techbiz Builder', 'techbiz' ),
            	esc_html__( 'Techbiz Builder', 'techbiz' ),
				'manage_options',
				'techbiz',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('techbiz', esc_html__('Footer Builder', 'techbiz'), esc_html__('Footer Builder', 'techbiz'), 'manage_options', 'edit.php?post_type=techbiz_footer');
			add_submenu_page('techbiz', esc_html__('Header Builder', 'techbiz'), esc_html__('Header Builder', 'techbiz'), 'manage_options', 'edit.php?post_type=techbiz_header');
			add_submenu_page('techbiz', esc_html__('Tab Builder', 'techbiz'), esc_html__('Tab Builder', 'techbiz'), 'manage_options', 'edit.php?post_type=techbiz_tab_build');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','techbiz' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'techbiz' ),
				'singular_name'      => __( 'Footer', 'techbiz' ),
				'menu_name'          => __( 'Techbiz Footer Builder', 'techbiz' ),
				'name_admin_bar'     => __( 'Footer', 'techbiz' ),
				'add_new'            => __( 'Add New', 'techbiz' ),
				'add_new_item'       => __( 'Add New Footer', 'techbiz' ),
				'new_item'           => __( 'New Footer', 'techbiz' ),
				'edit_item'          => __( 'Edit Footer', 'techbiz' ),
				'view_item'          => __( 'View Footer', 'techbiz' ),
				'all_items'          => __( 'All Footer', 'techbiz' ),
				'search_items'       => __( 'Search Footer', 'techbiz' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'techbiz' ),
				'not_found'          => __( 'No Footer found.', 'techbiz' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'techbiz' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'techbiz_footer', $args );

			$labels = array(
				'name'               => __( 'Header', 'techbiz' ),
				'singular_name'      => __( 'Header', 'techbiz' ),
				'menu_name'          => __( 'Techbiz Header Builder', 'techbiz' ),
				'name_admin_bar'     => __( 'Header', 'techbiz' ),
				'add_new'            => __( 'Add New', 'techbiz' ),
				'add_new_item'       => __( 'Add New Header', 'techbiz' ),
				'new_item'           => __( 'New Header', 'techbiz' ),
				'edit_item'          => __( 'Edit Header', 'techbiz' ),
				'view_item'          => __( 'View Header', 'techbiz' ),
				'all_items'          => __( 'All Header', 'techbiz' ),
				'search_items'       => __( 'Search Header', 'techbiz' ),
				'parent_item_colon'  => __( 'Parent Header:', 'techbiz' ),
				'not_found'          => __( 'No Header found.', 'techbiz' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'techbiz' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'techbiz_header', $args );

            $labels = array(
				'name'               => __( 'Tab Builder', 'techbiz' ),
				'singular_name'      => __( 'Tab Builder', 'techbiz' ),
				'menu_name'          => __( 'Foodelio Tab Builder', 'techbiz' ),
				'name_admin_bar'     => __( 'Tab Builder', 'techbiz' ),
				'add_new'            => __( 'Add New', 'techbiz' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'techbiz' ),
				'new_item'           => __( 'New Tab Builder', 'techbiz' ),
				'edit_item'          => __( 'Edit Tab Builder', 'techbiz' ),
				'view_item'          => __( 'View Tab Builder', 'techbiz' ),
				'all_items'          => __( 'All Tab Builder', 'techbiz' ),
				'search_items'       => __( 'Search Tab Builder', 'techbiz' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'techbiz' ),
				'not_found'          => __( 'No Tab Builder found.', 'techbiz' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'techbiz' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'techbiz_tab_build', $args );

		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'techbiz_footer' == $post->post_type || 'techbiz_header' == $post->post_type || 'techbiz_tab_build' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function techbiz_footer_choose_option(){

			$techbiz_post_query = new WP_Query( array(
				'post_type'			=> 'techbiz_footer',
				'posts_per_page'	    => -1,
			) );

			$techbiz_builder_post_title = array();
			$techbiz_builder_post_title[''] = __('Select a Footer','Techbiz');

			while( $techbiz_post_query->have_posts() ) {
				$techbiz_post_query->the_post();
				$techbiz_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $techbiz_builder_post_title;

		}

		public function techbiz_header_choose_option(){

			$techbiz_post_query = new WP_Query( array(
				'post_type'			=> 'techbiz_header',
				'posts_per_page'	    => -1,
			) );

			$techbiz_builder_post_title = array();
			$techbiz_builder_post_title[''] = __('Select a Header','Techbiz');

			while( $techbiz_post_query->have_posts() ) {
				$techbiz_post_query->the_post();
				$techbiz_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $techbiz_builder_post_title;

        }

    }

    $builder_execute = new TechbizBuilder();