<?php

    use Elementor\Controls_Manager;
    use Elementor\Group_Control_Typography;
    use Elementor\Plugin;
    use Elementor\Repeater;
    use Elementor\Utils;
    use Elementor\Widget_Base;

/**
 *
 * Counter Widget .
 *
 */
class Bizino_Service_Box extends Widget_Base{

    public function get_name(){
        return 'bizinoservicebox';
    }

    public function get_title(){
        return __( 'Service Box', 'bizino' );
    }

    public function get_icon(){
        return 'eicon-code';
    }

    public function get_categories(){
        return ['bizino'];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'service_box_section',
            [
                'label'     => __( 'Service Box', 'bizino' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'service_image',
            [
                'label'     => __('Service Image', 'bizino'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'       => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'service_title', [
                'label'         => __( 'Service Title', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Finance & Restructuring', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $this->add_control(
            'service_details_url', [
                'label'         => __( 'Service Details URL?', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( '#', 'bizino' ),
                'label_block'   => true,
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'title_styling',
            [
                'label' => __('Title Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'service_box_bg_color',
            [
                'label'     => __( 'Service BG Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-style6' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'service_title_color',
            [
                'label'     => __('Title Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-style6 .service-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'service_title_hover_color',
            [
                'label'     => __('Title Hover Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-style6 .service-title a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'service_title_typography',
                'label'     => __( 'Title Typography', 'bizino' ),
                'selector'  => '{{WRAPPER}} .service-style6 .service-title'
            ]
        );

        $this->add_responsive_control(
            'service_title_margin',
            [
                'label'         => __( 'Title Margin', 'bizino' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .service-style6 .service-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'service_title_padding',
            [
                'label'         => __( 'Title Padding', 'bizino' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .service-style6 .service-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render(){

        $settings = $this->get_settings_for_display();
        
        echo '<div class="service-style6">';
            if( ! empty( $settings['service_image']['url'] ) ){
                echo '<div class="service-icon">';
                    echo techbiz_img_tag( array(
                        'url'   => esc_url( $settings['service_image']['url'] )
                    ) );
                echo '</div>';
            }
            if( ! empty( $settings['service_title'] ) ){
                echo '<h3 class="service-title"><a href="'.esc_url( $settings['service_details_url'] ).'" class="text-inherit">'.esc_html( $settings['service_title'] ).'</a></h3>';
            }
        echo '</div>';
        
    }
}

Plugin::instance()->widgets_manager->register( new Bizino_Service_Box() );