<?php
namespace CHT\admin;
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class CHT_PRO_Social_Icons
 *
 * @since 1.0
 */

class CHT_PRO_Social_Icons
{

    protected $social_list;

    protected static $instance;


    private function __construct()
    {

    }//end __construct()


    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (!self::$instance) {
            self::$instance = new CHT_PRO_Social_Icons;
        }

        return self::$instance;

    }//end get_instance()


    // List of colors for widget
    public function get_colors()
    {
        return [
            '#A886CD' => __('Purple', 'chaty'),
            '#86CD91' => __('Green', 'chaty'),
            '#4F6ACA' => __('Blue', 'chaty'),
            '#FF6060' => __('Red', 'chaty'),
            '#000'    => __('Black', 'chaty'),
            '#EEF075' => __('Yellow', 'chaty'),
            '#FF95EE' => __('Pink', 'chaty'),
        ];

    }//end get_colors()


    // List of button types for widget
    public function get_widget_types()
    {
        return [
            'default' => 'default',
            'smile'   => 'smile',
            'points'  => 'points',
            'two'     => 'two',
            'custom'  => 'custom',
        ];

    }//end get_widget_types()


    // Social icon list for admin
    public function get_icons_list()
    {
        return [
            [
                'example'     => '1507854875',
                'placeholder' => __('Phone number', 'chaty'),
                'help_title'  => 'How do I use this?',
                'help'        => 'Enter your country code (in our example 1) and then your number without a leading zero (in our example 507854875)',
                'slug'        => 'Whatsapp',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#49E670"/>
                           <path d="M12.9821 10.1115C12.7029 10.7767 11.5862 11.442 10.7486 11.575C10.1902 11.7081 9.35269 11.8411 6.84003 10.7767C3.48981 9.44628 1.39593 6.25317 1.25634 6.12012C1.11674 5.85403 2.13001e-06 4.39053 2.13001e-06 2.92702C2.13001e-06 1.46351 0.83755 0.665231 1.11673 0.399139C1.39592 0.133046 1.8147 1.01506e-06 2.23348 1.01506e-06C2.37307 1.01506e-06 2.51267 1.01506e-06 2.65226 1.01506e-06C2.93144 1.01506e-06 3.21063 -2.02219e-06 3.35022 0.532183C3.62941 1.19741 4.32736 2.66092 4.32736 2.79397C4.46696 2.92702 4.46696 3.19311 4.32736 3.32616C4.18777 3.59225 4.18777 3.59224 3.90858 3.85834C3.76899 3.99138 3.6294 4.12443 3.48981 4.39052C3.35022 4.52357 3.21063 4.78966 3.35022 5.05576C3.48981 5.32185 4.18777 6.38622 5.16491 7.18449C6.42125 8.24886 7.39839 8.51496 7.81717 8.78105C8.09636 8.91409 8.37554 8.9141 8.65472 8.648C8.93391 8.38191 9.21309 7.98277 9.49228 7.58363C9.77146 7.31754 10.0507 7.1845 10.3298 7.31754C10.609 7.45059 12.2841 8.11582 12.5633 8.38191C12.8425 8.51496 13.1217 8.648 13.1217 8.78105C13.1217 8.78105 13.1217 9.44628 12.9821 10.1115Z" transform="translate(12.9597 12.9597)" fill="#FAFAFA"/>
                           <path d="M0.196998 23.295L0.131434 23.4862L0.323216 23.4223L5.52771 21.6875C7.4273 22.8471 9.47325 23.4274 11.6637 23.4274C18.134 23.4274 23.4274 18.134 23.4274 11.6637C23.4274 5.19344 18.134 -0.1 11.6637 -0.1C5.19344 -0.1 -0.1 5.19344 -0.1 11.6637C-0.1 13.9996 0.624492 16.3352 1.93021 18.2398L0.196998 23.295ZM5.87658 19.8847L5.84025 19.8665L5.80154 19.8788L2.78138 20.8398L3.73978 17.9646L3.75932 17.906L3.71562 17.8623L3.43104 17.5777C2.27704 15.8437 1.55796 13.8245 1.55796 11.6637C1.55796 6.03288 6.03288 1.55796 11.6637 1.55796C17.2945 1.55796 21.7695 6.03288 21.7695 11.6637C21.7695 17.2945 17.2945 21.7695 11.6637 21.7695C9.64222 21.7695 7.76778 21.1921 6.18227 20.039L6.17557 20.0342L6.16817 20.0305L5.87658 19.8847Z" transform="translate(7.7758 7.77582)" fill="white" stroke="white" stroke-width="0.2"/></svg>',
                'title'       => 'WhatsApp',
                'color'       => '#49E670',
                'attr'        => 'phone-number',
            ],
            [
                'example'     => 'https://m.me/Coca-Cola/',
                'placeholder' => __('https://m.me/Coca-Cola/', 'chaty'),
                'slug'        => 'Facebook_Messenger',
                'title'       => 'Facebook Messenger',
                'color'       => '#1E88E5',
                'help'        => "Your Facebook page has to be available to all ages and countries (check your page's settings).<br>If you can't find your page's URL, <a href='https://youtu.be/KKVRHyfc_9k' target='_blank'>click here</a> and follow our guide.",
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#1E88E5"/>
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0 9.63934C0 4.29861 4.68939 0 10.4209 0C16.1524 0 20.8418 4.29861 20.8418 9.63934C20.8418 14.98 16.1524 19.2787 10.4209 19.2787C9.37878 19.2787 8.33673 19.1484 7.42487 18.8879L3.90784 20.8418V17.1945C1.56311 15.3708 0 12.6353 0 9.63934ZM8.85779 10.1604L11.463 13.0261L17.1945 6.90384L12.1143 9.76959L9.37885 6.90384L3.64734 13.0261L8.85779 10.1604Z" transform="translate(9.01854 10.3146)" fill="white"/></svg>',
            ],
            [
                'example'     => '+1507854875',
                'placeholder' => __('Phone number', 'chaty'),
                'help_title'  => 'How do I use this?',
                'help'        => 'Enter your country code (in our example +1) and then your number without a leading zero (in our example 507854875)',
                'slug'        => 'Phone',
                'title'       => 'Phone',
                'color'       => '#03E78B',
                'attr'        => 'phone-number',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#03E78B"/>
                           <path d="M19.3929 14.9176C17.752 14.7684 16.2602 14.3209 14.7684 13.7242C14.0226 13.4259 13.1275 13.7242 12.8292 14.4701L11.7849 16.2602C8.65222 14.6193 6.11623 11.9341 4.47529 8.95057L6.41458 7.90634C7.16046 7.60799 7.45881 6.71293 7.16046 5.96705C6.56375 4.47529 6.11623 2.83435 5.96705 1.34259C5.96705 0.596704 5.22117 0 4.47529 0H0.745882C0.298353 0 5.69062e-07 0.298352 5.69062e-07 0.745881C5.69062e-07 3.72941 0.596704 6.71293 1.93929 9.3981C3.87858 13.575 7.30964 16.8569 11.3374 18.7962C14.0226 20.1388 17.0061 20.7355 19.9896 20.7355C20.4371 20.7355 20.7355 20.4371 20.7355 19.9896V16.4094C20.7355 15.5143 20.1388 14.9176 19.3929 14.9176Z" transform="translate(9.07179 9.07178)" fill="white"/></svg>',
            ],
            [
                'example'     => 'someone@example.com',
                'placeholder' => 'Email',
                'help_title'  => 'How do I use this?',
                'help'        => 'Learn more here <a href="https://premio.io/help/chaty/how-to-add-a-preset-mail-subject-to-your-email-channel/" target="_blank">https://premio.io/help/chaty/how-to-add-a-preset-mail-subject-to-your-email-channel/</a>',
                'slug'        => 'Email',
                'title'       => 'Email',
                'color'       => '#FF485F',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#FF485F"/>
                           <path d="M20.5379 14.2557H1.36919C0.547677 14.2557 0 13.7373 0 12.9597V1.29597C0 0.518387 0.547677 0 1.36919 0H20.5379C21.3594 0 21.9071 0.518387 21.9071 1.29597V12.9597C21.9071 13.7373 21.3594 14.2557 20.5379 14.2557ZM20.5379 12.9597V13.6077V12.9597ZM1.36919 1.29597V12.9597H20.5379V1.29597H1.36919Z" transform="translate(8.48619 12.3117)" fill="white"/>
                           <path d="M10.9659 8.43548C10.829 8.43548 10.692 8.43548 10.5551 8.30588L0.286184 1.17806C0.012346 0.918864 -0.124573 0.530073 0.149265 0.270879C0.423104 0.0116857 0.833862 -0.117911 1.1077 0.141283L10.9659 7.00991L20.8241 0.141283C21.0979 -0.117911 21.5087 0.0116857 21.7825 0.270879C22.0563 0.530073 21.9194 0.918864 21.6456 1.17806L11.3766 8.30588C11.2397 8.43548 11.1028 8.43548 10.9659 8.43548Z" transform="translate(8.47443 12.9478)" fill="white"/>
                           <path d="M9.0906 7.13951C8.95368 7.13951 8.81676 7.13951 8.67984 7.00991L0.327768 1.17806C-0.0829894 0.918864 -0.0829899 0.530073 0.190849 0.270879C0.327768 0.0116855 0.738525 -0.117911 1.14928 0.141282L9.50136 5.97314C9.7752 6.23233 9.91212 6.62112 9.63828 6.88032C9.50136 7.00991 9.36444 7.13951 9.0906 7.13951Z" transform="translate(20.6183 18.7799)" fill="white"/>
                           <path d="M0.696942 7.13951C0.423104 7.13951 0.286185 7.00991 0.149265 6.88032C-0.124573 6.62112 0.012346 6.23233 0.286185 5.97314L8.63826 0.141282C9.04902 -0.117911 9.45977 0.0116855 9.59669 0.270879C9.87053 0.530073 9.73361 0.918864 9.45977 1.17806L1.1077 7.00991C0.970781 7.13951 0.833862 7.13951 0.696942 7.13951Z" transform="translate(8.47443 18.7799)" fill="white"/></svg>',
            ],
            [
                'example'     => 'InstagramUsername',
                'placeholder' => __('InstagramUsername', 'chaty'),
                'slug'        => 'Instagram',
                'title'       => 'Instagram',
                'color'       => '#ffffff',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <circle class="color-element" cx="19.5" cy="19.5" r="19.5" fill="url(#linear-gradient)"/>
                      <path id="Path_1923" data-name="Path 1923" d="M13.177,0H5.022A5.028,5.028,0,0,0,0,5.022v8.155A5.028,5.028,0,0,0,5.022,18.2h8.155A5.028,5.028,0,0,0,18.2,13.177V5.022A5.028,5.028,0,0,0,13.177,0Zm3.408,13.177a3.412,3.412,0,0,1-3.408,3.408H5.022a3.411,3.411,0,0,1-3.408-3.408V5.022A3.412,3.412,0,0,1,5.022,1.615h8.155a3.412,3.412,0,0,1,3.408,3.408v8.155Z" transform="translate(10 10.4)" fill="#fff"/>
                      <path id="Path_1924" data-name="Path 1924" d="M45.658,40.97a4.689,4.689,0,1,0,4.69,4.69A4.695,4.695,0,0,0,45.658,40.97Zm0,7.764a3.075,3.075,0,1,1,3.075-3.075A3.078,3.078,0,0,1,45.658,48.734Z" transform="translate(-26.558 -26.159)" fill="#fff"/></svg>
                      <path id="Path_1925" data-name="Path 1925" d="M120.105,28.251a1.183,1.183,0,1,0,.838.347A1.189,1.189,0,0,0,120.105,28.251Z" transform="translate(-96.119 -14.809)" fill="#fff"/>',
                'svg_front'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><defs>
                        <linearGradient id="linear-gradient" x1="0.892" y1="0.192" x2="0.128" y2="0.85" gradientUnits="objectBoundingBox">
                          <stop offset="0" stop-color="#4a64d5"/>
                          <stop offset="0.322" stop-color="#9737bd"/>
                          <stop offset="0.636" stop-color="#f15540"/>
                          <stop offset="1" stop-color="#fecc69"/>
                        </linearGradient>
                      </defs>
                      <circle class="color-element" cx="19.5" cy="19.5" r="19.5" fill="url(#linear-gradient)"/>
                      <path id="Path_1923" data-name="Path 1923" d="M13.177,0H5.022A5.028,5.028,0,0,0,0,5.022v8.155A5.028,5.028,0,0,0,5.022,18.2h8.155A5.028,5.028,0,0,0,18.2,13.177V5.022A5.028,5.028,0,0,0,13.177,0Zm3.408,13.177a3.412,3.412,0,0,1-3.408,3.408H5.022a3.411,3.411,0,0,1-3.408-3.408V5.022A3.412,3.412,0,0,1,5.022,1.615h8.155a3.412,3.412,0,0,1,3.408,3.408v8.155Z" transform="translate(10 10.4)" fill="#fff"/>
                      <path id="Path_1924" data-name="Path 1924" d="M45.658,40.97a4.689,4.689,0,1,0,4.69,4.69A4.695,4.695,0,0,0,45.658,40.97Zm0,7.764a3.075,3.075,0,1,1,3.075-3.075A3.078,3.078,0,0,1,45.658,48.734Z" transform="translate(-26.558 -26.159)" fill="#fff"/></svg>
                      <path id="Path_1925" data-name="Path 1925" d="M120.105,28.251a1.183,1.183,0,1,0,.838.347A1.189,1.189,0,0,0,120.105,28.251Z" transform="translate(-96.119 -14.809)" fill="#fff"/>',
            ],
            [
                'example'     => '+1507854875',
                'placeholder' => __('Phone number', 'chaty'),
                'help_title'  => 'How do I use this?',
                'help'        => 'Enter your country code (in our example +1) and then your number without a leading zero (in our example 507854875)',
                'slug'        => 'SMS',
                'title'       => 'SMS',
                'color'       => '#FF549C',
                'attr'        => 'phone-number',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#FF549C"/>
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M2.60298 0H16.9194C18.351 0 19.5224 1.19321 19.5224 2.65158V14.5838C19.5224 16.0421 18.351 17.2354 16.9194 17.2354H7.4185L3.64418 20.4173C3.51402 20.5499 3.38388 20.5499 3.25372 20.5499H2.99344C2.73314 20.4173 2.60298 20.1521 2.60298 19.887V17.2354C1.17134 17.2354 0 16.0421 0 14.5838V2.65158C0 1.19321 1.17134 0 2.60298 0ZM2.60316 11.2696C2.60316 11.6673 2.86346 11.9325 3.25391 11.9325H4.5554C5.5966 11.9325 6.50764 11.0044 6.50764 9.94376C6.50764 8.88312 5.5966 7.95505 4.5554 7.95505C4.16496 7.95505 3.90465 7.68991 3.90465 7.29218C3.90465 6.89441 4.16496 6.62927 4.5554 6.62927H5.85689C6.24733 6.62927 6.50764 6.36411 6.50764 5.96637C6.50764 5.56863 6.24733 5.30347 5.85689 5.30347H4.5554C3.51421 5.30347 2.60316 6.23154 2.60316 7.29218C2.60316 8.35281 3.51421 9.28085 4.5554 9.28085C4.94585 9.28085 5.20613 9.54602 5.20613 9.94376C5.20613 10.3415 4.94585 10.6067 4.5554 10.6067H3.25391C2.86346 10.6067 2.60316 10.8718 2.60316 11.2696ZM14.9678 11.9325H13.6664C13.2759 11.9325 13.0156 11.6673 13.0156 11.2696C13.0156 10.8718 13.2759 10.6067 13.6664 10.6067H14.9678C15.3583 10.6067 15.6186 10.3415 15.6186 9.94376C15.6186 9.54602 15.3583 9.28085 14.9678 9.28085C13.9267 9.28085 13.0156 8.35281 13.0156 7.29218C13.0156 6.23154 13.9267 5.30347 14.9678 5.30347H16.2693C16.6598 5.30347 16.9201 5.56863 16.9201 5.96637C16.9201 6.36411 16.6598 6.62927 16.2693 6.62927H14.9678C14.5774 6.62927 14.3171 6.89441 14.3171 7.29218C14.3171 7.68991 14.5774 7.95505 14.9678 7.95505C16.009 7.95505 16.9201 8.88312 16.9201 9.94376C16.9201 11.0044 16.009 11.9325 14.9678 11.9325ZM10.4126 11.2697C10.4126 11.6674 10.6729 11.9326 11.0633 11.9326C11.4538 11.9326 11.7141 11.6674 11.8442 11.2697V5.96649C11.8442 5.70135 11.5839 5.43619 11.3236 5.30362C10.9332 5.30362 10.6729 5.43619 10.5427 5.70135L9.76186 7.15973L8.98094 5.70135C8.85081 5.43619 8.46034 5.17102 8.20006 5.30362C7.93977 5.43619 7.67946 5.70135 7.67946 5.96649V11.2697C7.67946 11.6674 7.93977 11.9326 8.33022 11.9326C8.72066 11.9326 8.98094 11.6674 8.98094 11.2697V8.75067L9.1111 8.88327C9.37138 9.28101 10.0221 9.28101 10.2825 8.88327L10.4126 8.75067V11.2697Z" transform="translate(9.67801 10.4601)" fill="white"/></svg>',
            ],
            [
                'example'     => '',
                'placeholder' => '',
                'slug'        => 'Contact_Us',
                'title'       => 'Contact Form',
                'color'       => '#253974',
                'svg'         => '<svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle class="color-element" cx="24" cy="24" r="24" fill="#253974"></circle> <path d="M34.5002 12.334H17.0002C16.3813 12.334 15.7878 12.5798 15.3502 13.0174C14.9127 13.455 14.6668 14.0485 14.6668 14.6673V18.1673H12.3335V20.5007H14.6668V22.834H12.3335V25.1673H14.6668V27.5007H12.3335V29.834H14.6668V33.334C14.6668 33.9528 14.9127 34.5463 15.3502 34.9839C15.7878 35.4215 16.3813 35.6673 17.0002 35.6673H34.5002C34.8096 35.6673 35.1063 35.5444 35.3251 35.3256C35.5439 35.1068 35.6668 34.8101 35.6668 34.5007V13.5007C35.6668 13.1912 35.5439 12.8945 35.3251 12.6757C35.1063 12.4569 34.8096 12.334 34.5002 12.334ZM25.1668 15.8328C27.0895 15.8328 28.6668 17.409 28.6668 19.3328C28.6635 20.2601 28.2937 21.1485 27.638 21.8044C26.9824 22.4602 26.0942 22.8303 25.1668 22.834C23.2453 22.834 21.6668 21.2555 21.6668 19.3328C21.6668 17.409 23.2453 15.8328 25.1668 15.8328ZM32.1668 31.0007H18.1668V30.1257C18.1668 27.5368 21.3227 24.8757 25.1668 24.8757C29.011 24.8757 32.1668 27.5368 32.1668 30.1257V31.0007Z" fill="white"></path> </svg>',
            ],
            [
                'example'     => 'https://app.popt.in/APIRequest/click/34e92354f927c',
                'placeholder' => __('Enter a poptin link', 'chaty'),
                'slug'        => 'Poptin',
                'title'       => 'Poptin Popups',
                'color'       => '#47A2B1',
                'help_title'  => 'How do I use this?',
                'help' => 'You can create a free poptin account by <a href="https://www.poptin.com/?utm_source=chatywp" target="_blank">clicking here</a>, and use it to create popups and forms on your site. You can also learn how to use <a href="https://premio.io/help/chaty/how-to-launch-a-poptin-pop-up-in-chaty/" target="_blank">Poptin and Chaty here</a>',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#47A2B1"/>
                            <rect width="21.351" height="17.0808" rx="1.73931" transform="translate(8.76428 12.1953)" fill="white"/>                            <rect width="18.2112" height="1.83009" rx="0.915044" transform="translate(10.0203 17.6851)" fill="#F2F2F2"/>                            <rect width="15.0713" height="1.83009" rx="0.915044" transform="translate(10.0203 20.1256)" fill="#F2F2F2"/>                            <rect width="8.16363" height="1.83009" rx="0.915044" transform="translate(15.0443 24.3958)" fill="#E0E0E0"/>                            <path d="M0 1.74C0 0.779025 0.779024 0 1.74 0H19.611C20.572 0 21.351 0.779025 21.351 1.74V3.20266H0V1.74Z" transform="translate(8.76428 12.1953)" fill="#E0E0E0"/></svg>',
            ],
            [
                'example'     => 'http://line.me/ti/p/2a-s5A2B8B',
                'placeholder' => __('User Name', 'chaty'),
                'slug'        => 'Line',
                'title'       => 'Line',
                'color'       => '#38B900',
                'help'        => '',
                'help_title'  => "Find your link",
                'help_link'   => "https://developers.line.biz/en/docs/messaging-api/sharing-bot/#url-scheme-to-link-to-the-add-friend-screen",
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#38B900"></circle>
                    <path d="M24 9.36561C24 4.19474 18.6178 0 12 0C5.38215 0 0 4.19474 0 9.36561C0 13.9825 4.25629 17.8606 10.0229 18.5993C10.4073 18.6785 10.9565 18.8368 11.0664 19.1797C11.1762 19.4699 11.1487 19.9184 11.0938 20.235C11.0938 20.235 10.9565 21.0528 10.9291 21.2111C10.8741 21.5013 10.6819 22.3456 11.9725 21.8443C13.2632 21.3167 18.8924 17.9398 21.3913 15.1433C23.1487 13.2702 24 11.4234 24 9.36561Z" transform="translate(7 10)" fill="white"></path>
                    <path d="M1.0984 0H0.24714C0.10984 0 -2.09503e-07 0.105528 -2.09503e-07 0.211056V5.22364C-2.09503e-07 5.35555 0.10984 5.43469 0.24714 5.43469H1.0984C1.2357 5.43469 1.34554 5.32917 1.34554 5.22364V0.211056C1.34554 0.105528 1.2357 0 1.0984 0Z" transform="translate(15.4577 16.8593)" fill="#38B900" class="color-element"></path>
                    <path d="M4.66819 0H3.81693C3.67963 0 3.56979 0.105528 3.56979 0.211056V3.19222L1.18078 0.0791458C1.18078 0.0791458 1.18078 0.0527642 1.15332 0.0527642C1.15332 0.0527642 1.15332 0.0527641 1.12586 0.0263821C1.12586 0.0263821 1.12586 0.0263821 1.0984 0.0263821H0.247139C0.10984 0.0263821 4.19006e-07 0.13191 4.19006e-07 0.237438V5.25002C4.19006e-07 5.38193 0.10984 5.46108 0.247139 5.46108H1.0984C1.2357 5.46108 1.34554 5.35555 1.34554 5.25002V2.26885L3.73455 5.38193C3.76201 5.40831 3.76201 5.43469 3.78947 5.43469C3.78947 5.43469 3.78947 5.43469 3.81693 5.43469C3.81693 5.43469 3.81693 5.43469 3.84439 5.43469C3.87185 5.43469 3.87185 5.43469 3.89931 5.43469H4.75057C4.88787 5.43469 4.99771 5.32917 4.99771 5.22364V0.211056C4.91533 0.105528 4.80549 0 4.66819 0Z" transform="translate(17.6819 16.8593)" fill="#38B900" class="color-element"></path>
                    <path d="M3.62471 4.22112H1.34554V0.237438C1.34554 0.105528 1.2357 0 1.0984 0H0.24714C0.10984 0 -5.23757e-08 0.105528 -5.23757e-08 0.237438V5.25002C-5.23757e-08 5.30278 0.0274599 5.35555 0.0549198 5.40831C0.10984 5.43469 0.16476 5.46108 0.21968 5.46108H3.56979C3.70709 5.46108 3.78947 5.35555 3.78947 5.22364V4.4058C3.87185 4.32665 3.76201 4.22112 3.62471 4.22112Z" transform="translate(10.8993 16.8593)" fill="#38B900" class="color-element"></path>
                    <path d="M3.56979 1.29272C3.70709 1.29272 3.78947 1.18719 3.78947 1.05528V0.237438C3.78947 0.105528 3.67963 -1.00639e-07 3.56979 -1.00639e-07H0.219679C0.164759 -1.00639e-07 0.10984 0.0263821 0.0549199 0.0527641C0.02746 0.105528 -2.09503e-07 0.158292 -2.09503e-07 0.211056V5.22364C-2.09503e-07 5.2764 0.02746 5.32917 0.0549199 5.38193C0.10984 5.40831 0.164759 5.43469 0.219679 5.43469H3.56979C3.70709 5.43469 3.78947 5.32917 3.78947 5.19726V4.37941C3.78947 4.2475 3.67963 4.14198 3.56979 4.14198H1.29062V3.29775H3.56979C3.70709 3.29775 3.78947 3.19222 3.78947 3.06031V2.24247C3.78947 2.11056 3.67963 2.00503 3.56979 2.00503H1.29062V1.16081H3.56979V1.29272Z" transform="translate(23.421 16.8329)" fill="#38B900" class="color-element"></path></svg>',
            ],
            [
                'example'     => 'myusername',
                'placeholder' => __('User Name', 'chaty'),
                'slug'        => 'Telegram',
                'title'       => 'Telegram',
                'color'       => '#3E99D8',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#3E99D8"/>
                           <path d="M3.56917 -2.55497e-07L0 6.42978L7.5349 1.87535L3.56917 -2.55497e-07Z" transform="translate(13.9704 24.6145)" fill="#E0E0E0"/>
                           <path d="M20.8862 0.133954C20.754 0 20.4897 0 20.2253 0L0.396574 8.03723C0.132191 8.17118 0 8.43909 0 8.707C0 8.97491 0.132191 9.24282 0.396574 9.37677L17.5814 17.414C17.7136 17.414 17.7136 17.414 17.8458 17.414C17.978 17.414 18.1102 17.414 18.1102 17.28C18.2424 17.1461 18.3746 17.0121 18.5068 16.7442L21.1506 0.669769C21.1506 0.535815 21.1506 0.267908 20.8862 0.133954Z" transform="translate(7.36069 10.9512)" fill="white"/>
                           <path d="M13.8801 0L0 11.52V19.4233L3.70136 13.2614L13.8801 0Z" transform="translate(13.9704 11.6208)" fill="#F2F2F2"/></svg>',
            ],
            [
                'example'     => 'https://goo.gl/maps/4m93C84v2DC2',
                'placeholder' => __('Maps link', 'chaty'),
                'slug'        => 'Google_Maps',
                'title'       => 'Google Maps',
                'color'       => '#37AA66',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#37AA66"/>
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0 8.06381C0 3.68631 3.68633 0 8.06383 0C12.4413 0 16.1276 3.68631 16.1276 8.06381C16.1276 12.2109 9.67659 19.5835 8.9854 20.2747C8.755 20.5051 8.29422 20.7355 8.06383 20.7355C7.83344 20.7355 7.37263 20.5051 7.14224 20.2747C6.45107 19.5835 0 12.2109 0 8.06381ZM11.5203 8.06378C11.5203 9.97244 9.97302 11.5197 8.06436 11.5197C6.15572 11.5197 4.60844 9.97244 4.60844 8.06378C4.60844 6.15515 6.15572 4.60788 8.06436 4.60788C9.97302 4.60788 11.5203 6.15515 11.5203 8.06378Z" transform="translate(11.3764 9.07178)" fill="white"/></svg>',
            ],
            [
                'example'     => '+1507854875',
                'placeholder' => __('Phone number', 'chaty'),
                'slug'        => 'Viber',
                'title'       => 'Viber',
                'color'       => '#665CAC',
                'attr'        => 'phone-number',
                'help'        => 'Try to remove the "+" and your country code',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#665CAC"/>
                           <path d="M17.6837 2.14833C17.16 1.64578 15.0497 0.0389578 10.3496 0.0158143C10.3496 0.0158143 4.80418 -0.334645 2.10085 2.26405C0.596193 3.84111 0.0662511 6.14886 0.0126261 9.01205C-0.0441534 11.8752 -0.116705 17.2346 4.8168 18.6894H4.81995L4.8168 20.9078C4.8168 20.9078 4.78525 21.8071 5.3499 21.989C6.03125 22.2105 6.43186 21.5294 7.08482 20.7921C7.44127 20.3888 7.93651 19.7936 8.30874 19.3407C11.6808 19.6382 14.2769 18.9572 14.5702 18.858C15.2516 18.6265 19.1063 18.1075 19.7309 12.7481C20.3775 7.22338 19.4154 3.7254 17.6837 2.14833ZM18.2546 12.3513C17.7247 16.828 14.5986 17.1123 14.0245 17.3041C13.7785 17.3867 11.501 17.9818 8.63679 17.7835C8.63679 17.7835 6.50126 20.4813 5.83567 21.1856C5.73158 21.2947 5.60856 21.341 5.52654 21.3178C5.41298 21.2881 5.38144 21.1459 5.38144 20.9376C5.38459 20.64 5.40037 17.2512 5.40037 17.2512C5.39721 17.2512 5.39721 17.2512 5.40037 17.2512C1.23023 16.0378 1.47312 11.4719 1.52044 9.08148C1.56775 6.69108 1.99675 4.73379 3.26798 3.41792C5.55493 1.24904 10.2645 1.57305 10.2645 1.57305C14.2422 1.59288 16.1475 2.84594 16.5891 3.26583C18.0527 4.58501 18.8003 7.73585 18.2546 12.3513Z" transform="translate(9.47299 8.4238)" fill="white"/>                           <path d="M1.58982 1.72254C1.53935 0.628182 1.00941 0.0562059 0 1.00898e-07" transform="translate(20.166 15.5914)" stroke="white" stroke-width="0.518873" stroke-linecap="round" stroke-linejoin="round"/>                           <path d="M3.35945 3.69636C3.38153 2.67804 3.09448 1.82834 2.49514 1.14395C1.8958 0.459565 1.06619 0.0793496 1.9253e-07 2.01796e-07" transform="translate(19.7592 14.0966)" stroke="white" stroke-width="0.518873" stroke-linecap="round" stroke-linejoin="round"/>                           <path d="M5.22371 5.71646C5.21109 3.94763 4.70639 2.55902 3.71275 1.5407C2.71911 0.525689 1.47942 0.00991877 -3.8506e-07 1.00898e-07" transform="translate(19.2931 12.6479)" stroke="white" stroke-width="0.518873" stroke-linecap="round" stroke-linejoin="round"/>                           <path d="M6.35738 8.04532C6.35738 8.04532 6.73276 8.07838 6.93149 7.81719L7.32263 7.30142C7.5119 7.04353 7.96929 6.88153 8.41722 7.14272C8.66641 7.2915 9.11434 7.57914 9.39193 7.79405C9.68844 8.02218 10.2972 8.55448 10.2972 8.55448C10.5875 8.80906 10.6537 9.18597 10.4581 9.58271C10.4581 9.58602 10.455 9.58933 10.455 9.58933C10.2531 9.96293 9.9818 10.3167 9.63797 10.644C9.63482 10.6473 9.63482 10.6473 9.63167 10.6506C9.35092 10.8953 9.07333 11.0375 8.80205 11.0705C8.77051 11.0771 8.7295 11.0804 8.68219 11.0771C8.56232 11.0771 8.44561 11.0606 8.32889 11.0209L8.31943 11.0077C7.89989 10.8854 7.20277 10.5746 6.03879 9.90342C5.28173 9.467 4.654 9.02066 4.12406 8.57762C3.84331 8.34619 3.55626 8.08169 3.2629 7.77752C3.25344 7.7676 3.24398 7.75768 3.23451 7.74776C3.22505 7.73784 3.21559 7.72792 3.20612 7.718C3.19666 7.70808 3.1872 7.69817 3.17773 7.68825C3.16827 7.67833 3.15881 7.66841 3.14934 7.65849C2.85914 7.35101 2.60678 7.05015 2.38597 6.75589C1.96328 6.20045 1.53744 5.5392 1.12105 4.74902C0.480708 3.52902 0.184194 2.79834 0.0674803 2.35862L0.0548623 2.3487C0.0170094 2.22637 -0.00191702 2.10404 0.0012374 1.9784C-0.00191702 1.92881 0.0012373 1.88583 0.00754613 1.85276C0.0390903 1.56843 0.17473 1.27748 0.408157 0.983227C0.411312 0.979921 0.411311 0.979921 0.414466 0.976615C0.726753 0.616237 1.06112 0.331902 1.42072 0.120304C1.42388 0.120304 1.42703 0.116997 1.42703 0.116997C1.80556 -0.0879887 2.16517 -0.0185578 2.40806 0.285615C2.41121 0.288921 2.91592 0.923716 3.13357 1.2345C3.33861 1.52875 3.6162 1.99493 3.75499 2.25612C4.00419 2.72561 3.84962 3.20501 3.60358 3.40338L3.11149 3.81335C2.86229 4.02495 2.89384 4.41509 2.89384 4.41509C2.89384 4.41509 3.62566 7.31464 6.35738 8.04532Z" transform="translate(13.863 13.0014)" fill="white"/></svg>',
            ],
            [
                'example'     => 'MyTwitterHandle',
                'placeholder' => __('Twitter', 'chaty'),
                'slug'        => 'Twitter',
                'title'       => 'Twitter',
                'color'       => '#1ab2e8',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.5" cy="19.5" r="19.5" fill="#1ab2e8"/>
                            <path id="path_color_twitter" d="M18.532,59.222a7.592,7.592,0,0,1-2.183.6,3.817,3.817,0,0,0,1.671-2.1,7.664,7.664,0,0,1-2.416.923,3.8,3.8,0,0,0-6.478,3.466,10.792,10.792,0,0,1-7.835-3.972A3.806,3.806,0,0,0,2.469,63.21a3.8,3.8,0,0,1-1.722-.477v.047A3.805,3.805,0,0,0,3.8,66.508a3.85,3.85,0,0,1-1,.133,3.649,3.649,0,0,1-.716-.071,3.8,3.8,0,0,0,3.55,2.64A7.627,7.627,0,0,1,.908,70.835,8.079,8.079,0,0,1,0,70.783a10.745,10.745,0,0,0,5.827,1.71A10.741,10.741,0,0,0,16.643,61.678l-.013-.492A7.591,7.591,0,0,0,18.532,59.222Z" transform="translate(9.999 -45.441)" fill="#fff"/></svg>',
            ],
            [
                'example'     => 'UserID',
                'placeholder' => __('User Name', 'chaty'),
                'slug'        => 'WeChat',
                'title'       => 'WeChat',
                'color'       => '#45DC00',
                'help'        => "Unfortunately, WeChat doesn't have a click-to-chat API, therefore we can only show your username on-click so visitors can look-up for it. We have a QR upload option available in the pro plan",
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#45DC00"></circle>
                    <path d="M17.3707 6.90938C15.0508 7.03077 13.0281 7.71242 11.3888 9.26248C9.73039 10.8312 8.97307 12.7455 9.18397 15.1172C8.27327 15.0052 7.44884 14.8838 6.61482 14.8184C6.32723 14.7904 5.99171 14.8278 5.74246 14.9585C4.93721 15.4067 4.16071 15.9016 3.24042 16.4619C3.41298 15.7242 3.51843 15.0705 3.71015 14.4449C3.85395 13.9874 3.78685 13.7353 3.35546 13.4364C0.584998 11.5222 -0.594125 8.65553 0.287821 5.69547C1.10266 2.95952 3.09663 1.30674 5.80957 0.447674C9.50991 -0.728879 13.68 0.475687 15.9232 3.33303C16.738 4.36952 17.2365 5.53673 17.3707 6.90938ZM6.69152 5.98494C6.71069 5.44336 6.23137 4.95779 5.65619 4.93912C5.07142 4.92044 4.5921 5.35932 4.57293 5.91958C4.55375 6.48918 5.00431 6.94673 5.58908 6.95607C6.18344 6.97474 6.67234 6.53587 6.69152 5.98494ZM12.2612 4.93912C11.686 4.94846 11.2067 5.42468 11.2163 5.96627C11.2259 6.52653 11.7052 6.9654 12.29 6.9654C12.8843 6.95607 13.3253 6.51719 13.3253 5.93825C13.3157 5.37799 12.846 4.92978 12.2612 4.93912Z" transform="translate(7 9)" fill="white"></path>
                    <path d="M12.48 13.2605C11.7418 12.943 11.0708 12.4668 10.3518 12.3921C9.63283 12.3174 8.88509 12.7189 8.13735 12.7936C5.8558 13.0177 3.8139 12.4014 2.13629 10.8887C-1.06556 8.00334 -0.605416 3.57726 3.09492 1.21482C6.38305 -0.886168 11.2146 -0.185839 13.5345 2.72753C15.5572 5.26739 15.3175 8.64764 12.8538 10.786C12.1349 11.4023 11.876 11.9158 12.3362 12.7282C12.4225 12.8776 12.432 13.0737 12.48 13.2605ZM4.11108 5.3701C4.58081 5.3701 4.96426 5.01527 4.98344 4.56706C5.00261 4.09084 4.60957 3.68932 4.12066 3.68932C3.63176 3.68932 3.22913 4.09084 3.2483 4.55772C3.26748 5.00593 3.65093 5.3701 4.11108 5.3701ZM9.5082 3.68932C9.05764 3.68932 8.6646 4.04415 8.64543 4.49236C8.62626 4.96858 9.00971 5.36077 9.48903 5.36077C9.95876 5.36077 10.3326 5.01527 10.3422 4.55772C10.371 4.09084 9.98752 3.68932 9.5082 3.68932Z" transform="translate(17.1057 16.7395)" fill="white"></path></svg>',
            ],
            [
                'example'     => 'myusername',
                'placeholder' => __('Username', 'chaty'),
                'slug'        => 'Snapchat',
                'title'       => 'Snapchat',
                'color'       => '#FFE81D',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#FFE81D"/>
                           <path d="M21.5684 15.5864C18.7017 15.0298 17.3366 12.1073 17.3366 11.9681C17.2001 11.6898 17.2001 11.4115 17.2001 11.2723C17.3366 10.8548 18.0191 10.7157 18.4287 10.5765C18.5652 10.5765 18.7017 10.4373 18.7017 10.4373C19.1112 10.2982 19.3842 10.159 19.5207 9.88067C19.7938 9.60234 19.7938 9.46318 19.7938 9.32402C19.7938 8.90652 19.5207 8.62819 19.1112 8.48903C18.9747 8.48903 18.8382 8.34986 18.7017 8.34986C18.5652 8.34986 18.4287 8.34986 18.2922 8.48903C17.8826 8.62819 17.6096 8.76736 17.3366 8.76736C17.2001 8.76736 17.0636 8.76736 17.0636 8.76736C17.0636 8.62819 17.0636 8.48903 17.0636 8.34986C17.2001 6.81906 17.3366 5.00992 16.7906 3.8966C16.5175 3.20078 15.9715 2.50496 15.4255 1.9483C15.016 1.53081 14.4699 1.11332 13.7874 0.834987C12.6953 4.97691e-07 11.7397 0 11.3302 0C11.1937 0 10.9207 0 10.9207 0C10.3747 0 9.4191 0.139164 8.46354 0.556657C7.9175 0.834986 7.37147 1.25248 6.82544 1.66997C6.2794 2.22663 5.86988 2.92245 5.46035 3.61827C4.91431 4.73159 5.05082 6.54073 5.18733 8.07153C5.18733 8.2107 5.18733 8.34986 5.18733 8.62819C5.05082 8.62819 5.05082 8.62819 4.77781 8.62819C4.50479 8.62819 4.23177 8.48903 3.82224 8.34986C3.68574 8.34986 3.54923 8.2107 3.41272 8.2107C3.1397 8.2107 3.00319 8.2107 2.73018 8.34986C2.45716 8.48903 2.32065 8.76736 2.32065 8.90652C2.32065 9.04568 2.32065 9.32401 2.59366 9.74151C2.73017 9.88067 3.00319 10.0198 3.41272 10.159C3.54923 10.159 3.54922 10.2982 3.68573 10.2982C4.09526 10.4373 4.6413 10.5765 4.91431 10.994C5.05082 11.1332 4.91431 11.4115 4.77781 11.6898C4.77781 11.829 4.36828 12.5248 3.68573 13.3598C3.27621 13.7773 2.86668 14.1948 2.32065 14.6123C1.77461 15.0298 1.09207 15.3081 0.409527 15.3081C0.13651 15.3081 2.08296e-06 15.5864 2.08296e-06 15.8647C2.08296e-06 16.0039 2.08296e-06 16.0039 2.08296e-06 16.1431C0.136511 16.4214 0.409528 16.5606 0.682546 16.8389C1.22858 17.1172 1.91112 17.2564 2.86668 17.3955C2.86668 17.5347 3.00319 17.6739 3.00319 17.813C3.00319 17.9522 3.1397 18.0914 3.1397 18.3697C3.1397 18.5089 3.41272 18.7872 3.68573 18.7872C3.82224 18.7872 3.95875 18.7872 4.23177 18.648C4.50479 18.648 4.91431 18.5089 5.32384 18.5089C5.59686 18.5089 5.86988 18.5089 6.14289 18.648C6.68893 18.7872 7.09845 19.0655 7.64449 19.483C8.46354 20.0397 9.28259 20.7355 10.6477 20.7355H10.7842H10.9207C12.2858 20.7355 13.1048 20.0397 13.9239 19.483C14.4699 19.0655 14.8794 18.7872 15.4255 18.648C15.6985 18.648 15.9715 18.5089 16.2445 18.5089C16.6541 18.5089 17.0636 18.5089 17.3366 18.648C17.6096 18.648 17.7461 18.648 17.8826 18.648C18.1557 18.648 18.4287 18.5089 18.4287 18.2305C18.4287 18.0914 18.5652 17.9522 18.5652 17.6739C18.5652 17.5347 18.7017 17.2564 18.7017 17.2564C19.6572 17.1172 20.3398 16.9781 20.8858 16.6997C21.2954 16.5606 21.5684 16.2822 21.5684 16.0039C21.5684 15.8647 21.5684 15.8647 21.5684 15.7256C21.9779 15.8647 21.8414 15.5864 21.5684 15.5864Z" transform="translate(8.52631 9.07178)" fill="white"/></svg>',
            ],
            [
                'example'     => '@TikTok_username',
                'placeholder' => __('@TikTok_username', 'chaty'),
                'slug'        => 'TikTok',
                'title'       => 'TikTok',
                'color'       => '#000100',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#000100" />
                        <path stroke="null" d="m29.11825,14.02763c-1.25151,0 -2.40924,-0.41538 -3.33648,-1.11484c-1.06393,-0.80129 -1.83038,-1.98045 -2.10105,-3.33648c-0.067,-0.33498 -0.10183,-0.6807 -0.10451,-1.03712l-3.58035,0l0,9.78165l-0.00268,5.35445c0,1.43375 -0.9326,2.64775 -2.227,3.07385c-0.37519,0.12595 -0.77986,0.18223 -1.20328,0.16079c-0.53598,-0.02948 -1.04248,-0.19296 -1.47931,-0.45558c-0.93529,-0.55742 -1.56775,-1.57042 -1.58382,-2.72814c-0.0268,-1.81162 1.43643,-3.28824 3.24537,-3.28824c0.35643,0 0.69945,0.05896 1.02104,0.16348l0,-3.63396c-0.33767,-0.04824 -0.68338,-0.07503 -1.03176,-0.07503c-1.98045,0 -3.83227,0.82273 -5.15613,2.30739c-1.00228,1.1202 -1.60259,2.54859 -1.6937,4.04933c-0.12328,1.96973 0.59762,3.84299 1.99653,5.22314c0.20635,0.20367 0.42074,0.39127 0.64586,0.56546c1.19792,0.92189 2.66383,1.42303 4.20745,1.42303c0.34839,0 0.69409,-0.02679 1.03176,-0.07772c1.44179,-0.21171 2.77102,-0.87365 3.82154,-1.91077c1.28904,-1.27564 2.00189,-2.96666 2.00994,-4.76755l-0.01877,-7.99952c0.61638,0.47434 1.28904,0.86829 2.00994,1.17112c1.12288,0.47434 2.31544,0.71554 3.54016,0.71554l0,-3.56428c0,0 -0.01072,0 -0.01072,0l-0.00001,0zm0,0" fill="#fff" fill-rule="nonzero"/></svg>',
            ],
            [
                'example'     => 'myusername',
                'placeholder' => 'Skype',
                'title'       => 'Skype',
                'slug'        => 'Skype',
                'color'       => '#03A9F4',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#03A9F4"/>
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M10.5634 0.777588C16.0406 0.777588 20.4747 5.05426 20.4747 10.4973C20.4747 11.1453 20.4747 11.9229 20.0834 12.5709C20.4747 13.2189 20.7355 14.1261 20.7355 15.0332C20.7355 18.1436 18.1273 20.7355 14.9974 20.7355C13.9541 20.7355 13.0412 20.4763 12.2587 20.0875C11.6067 20.2171 11.085 20.2171 10.433 20.2171C4.95566 20.2171 0.521637 15.9404 0.521637 10.4973C0.521637 9.84955 0.652008 9.20175 0.782349 8.55392L0.782471 8.55338C0.260834 7.77582 0 6.73904 0 5.70227C0 2.59195 2.60825 0 5.73813 0C6.91183 0 7.95514 0.388794 8.86801 0.907166C9.38965 0.777588 10.0417 0.777588 10.5634 0.777588ZM13.5627 16.718C14.4756 16.3292 15.1276 15.8108 15.6493 15.1628C16.1709 14.5149 16.3013 13.7373 16.0405 12.9597C16.0405 12.3117 15.9101 11.7933 15.6493 11.2749C15.3884 10.7565 14.9972 10.3677 14.4756 10.1086L14.4752 10.1084C13.9536 9.84924 13.4321 9.59012 12.7802 9.33096C12.5034 9.27597 12.2031 9.1976 11.8893 9.11572C11.4638 9.0047 11.0135 8.88718 10.5632 8.81259C10.1953 8.66635 9.86893 8.60263 9.60748 8.55157C9.40552 8.51215 9.24231 8.48029 9.12866 8.4238C8.86792 8.4238 8.60721 8.29428 8.34647 8.16473L8.34619 8.16461C8.08536 8.035 7.82455 7.90543 7.69412 7.77582C7.43329 7.64621 7.43329 7.51663 7.43329 7.25742C7.43329 6.86862 7.69412 6.60944 8.08536 6.35025C8.47659 6.09106 9.12866 5.96146 9.78073 5.96146C10.5632 5.96146 11.0848 6.09106 11.4761 6.35025C11.8673 6.60944 12.1281 6.86865 12.3889 7.38702C12.6497 7.77563 12.9104 8.03476 13.0408 8.16443L13.041 8.16461C13.3018 8.29419 13.5627 8.4238 13.9539 8.4238C14.3451 8.4238 14.7364 8.29419 14.9972 8.035C15.258 7.77582 15.3884 7.51663 15.3884 7.12784C15.3884 6.73904 15.3884 6.35025 15.1276 5.96146C15.0313 5.67429 14.7927 5.45782 14.5169 5.20764C14.4193 5.11908 14.317 5.02631 14.2147 4.92468C13.6931 4.6655 13.1714 4.40631 12.5194 4.14709C11.8673 4.01752 11.0848 3.88791 10.172 3.88791C9.12866 3.88791 8.08536 4.01752 7.30289 4.2767C6.39001 4.53589 5.73795 5.05429 5.34671 5.57266C4.95547 6.09106 4.69464 6.73904 4.69464 7.51663C4.69464 8.29419 4.95547 8.9422 5.34671 9.46057C5.73795 9.97897 6.39001 10.3677 7.04205 10.627C7.69412 10.8861 8.60703 11.1453 9.6503 11.4045C10.4328 11.5341 11.0848 11.6637 11.4761 11.7933C11.8673 11.9229 12.2585 12.0525 12.5194 12.3117C12.7802 12.5709 12.9106 12.8301 12.9106 13.2189C12.9106 13.6077 12.6498 13.9965 12.1281 14.3853C11.6065 14.774 10.9544 14.9036 10.172 14.9036C9.6503 14.9036 9.12866 14.774 8.73743 14.6444C8.47659 14.5149 8.21576 14.2556 7.95496 13.9965C7.91547 13.918 7.86407 13.8277 7.80792 13.7291C7.67859 13.5019 7.52423 13.2308 7.43329 12.9597C7.40817 12.9098 7.38306 12.855 7.35703 12.7983C7.24783 12.5604 7.12225 12.2867 6.91165 12.1821C6.65085 12.0525 6.39001 11.9229 5.99878 11.9229C5.60754 11.9229 5.21631 12.0525 4.95547 12.3117C4.69464 12.5709 4.56424 12.8301 4.56424 13.2189C4.56424 13.8669 4.82507 14.3853 5.21631 15.0332C5.73795 15.6812 6.25961 16.07 6.91165 16.4588C7.82455 16.9772 8.99823 17.2364 10.4328 17.2364C11.6065 17.2364 12.6498 17.1068 13.5627 16.718Z" transform="translate(9.07178 9.07178)" fill="white"/></svg>',
            ],
            [
                'example'     => 'https://waze.com/ul/hdr5ru7vtv',
                'placeholder' => __('Enter a waze link', 'chaty'),
                'slug'        => 'Waze',
                'title'       => 'Waze',
                'color'       => '#6ECCEF',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#6ECCEF"/>
                            <path d="M11.6549 16.6733C16.5911 16.6733 20.5675 12.9218 20.5675 8.33667C20.5675 3.7515 16.5911 0 11.6549 0C6.7187 0 2.74233 3.7515 2.74233 8.33667C2.74233 8.33667 3.42791 12.505 0 12.505C0 15.9786 6.17024 16.6733 11.6549 16.6733Z" transform="translate(9.15631 9.71375)"
                                  fill="#6ECCEF" class="color-element"/>                            <path d="M12.3405 18.0628C3.97637 18.0628 0 16.5344 0 13.1997C0 12.7829 0.274233 12.505 0.685582 12.505C1.37116 12.505 1.91963 12.3661 2.19386 11.9492C3.01656 10.9766 2.74233 9.17034 2.74233 9.17034C2.74233 4.02939 6.99293 0 12.3405 0C17.688 0 21.9386 4.02939 21.9386 9.0314C21.9386 14.0334 17.688 18.0628 12.3405 18.0628ZM1.50828 13.7555C2.19386 15.5618 5.896 16.6733 12.3405 16.6733C16.8653 16.6733 20.5675 13.1997 20.5675 9.0314C20.5675 4.86306 16.8653 1.38945 12.3405 1.38945C7.81563 1.38945 4.11349 4.86306 4.11349 9.0314C4.11349 9.0314 4.52484 11.3935 3.29079 12.7829C2.74233 13.3387 2.19386 13.6166 1.50828 13.7555Z" transform="translate(8.46936 9.01862)" fill="white"/>                            <path d="M2.74233 5.55778C4.25687 5.55778 5.48465 4.31363 5.48465 2.77889C5.48465 1.24415 4.25687 0 2.74233 0C1.22778 0 0 1.24415 0 2.77889C0 4.31363 1.22778 5.55778 2.74233 5.55778Z" transform="translate(20.8105 24.3027)" fill="white"/>                            <path d="M2.74233 5.55778C4.25687 5.55778 5.48465 4.31363 5.48465 2.77889C5.48465 1.24415 4.25687 0 2.74233 0C1.22778 0 0 1.24415 0 2.77889C0 4.31363 1.22778 5.55778 2.74233 5.55778Z" transform="translate(12.5836 24.3025)" fill="white"/>                            <path d="M0.685582 1.38945C0.274233 1.38945 0 1.11156 0 0.694723C0 0.277889 0.274233 0 0.685582 0C1.09693 0 1.37116 0.277889 1.37116 0.694723C1.37116 1.11156 1.09693 1.38945 0.685582 1.38945Z" transform="translate(17.3835 15.2717)" fill="white"/>                            <path d="M0.685582 1.38945C0.274233 1.38945 0 1.11156 0 0.694723C0 0.277889 0.274233 0 0.685582 0C1.09693 0 1.37116 0.277889 1.37116 0.694723C1.37116 1.11156 1.09693 1.38945 0.685582 1.38945Z" transform="translate(22.8668 15.2717)" fill="white"/>                            <path d="M4.14916 4.20448C2.22953 4.20448 0.447017 2.81503 0.035668 0.869809C-0.101448 0.452975 0.172786 0.175088 0.584135 0.0361436C0.995484 -0.102801 1.26972 0.17509 1.40683 0.591924C1.68106 1.84242 2.77799 2.81503 4.14916 2.81503C5.52032 2.81503 6.61725 1.84242 6.89148 0.591924C7.0286 0.17509 7.30283 0.0361436 7.71418 0.0361436C8.12553 0.175088 8.26265 0.452975 8.26265 0.869809C7.8513 2.81503 6.06879 4.20448 4.14916 4.20448Z" transform="translate(16.662 18.7092)" fill="white"/></svg>',
            ],
            [
                'example'     => 'My-Name-512b1413b',
                'placeholder' => __('My-Name-512b1413b', 'chaty'),
                'slug'        => 'Linkedin',
                'title'       => 'Linkedin',
                'color'       => '#0077b5',
                'help'        => "To find your username and suffix, go to your <a href='https://www.linkedin.com/' target='_blank'>LinkedIn account</a> and click on your profile picture. Once you see your profile, copy the last part of the URL after https://www.linkedin.com/in/",
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.5" cy="19.5" r="19.5" fill="#0077b5"/>
                      <path id="LinkedIn_color" d="M18,20.1v6.655H14.142V20.549c0-1.56-.558-2.624-1.954-2.624a2.111,2.111,0,0,0-1.98,1.411,2.64,2.64,0,0,0-.128.941v6.481H6.221s.052-10.516,0-11.606H10.08V16.8c-.008.012-.018.026-.025.037h.025V16.8a3.832,3.832,0,0,1,3.478-1.918C16.1,14.88,18,16.539,18,20.1ZM2.184,9.558a2.011,2.011,0,1,0-.051,4.011h.026a2.012,2.012,0,1,0,.025-4.011ZM.229,26.758H4.087V15.152H.229Z" transform="translate(11 1.442)" fill="#fff"/></svg>',
            ],
            [
                'example'     => 'myusername',
                'placeholder' => __('Link Vkontakte', 'chaty'),
                'slug'        => 'Vkontakte',
                'title'       => 'Vkontakte',
                'color'       => '#5076AA',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#5076AA"/>
                           <path d="M11.0953 12.4775H12.5097C12.5097 12.4775 12.934 12.4774 13.0755 12.1971C13.2169 12.0569 13.2169 11.6363 13.2169 11.6363C13.2169 11.6363 13.2169 9.81373 14.0656 9.53334C14.9142 9.25294 15.9043 11.2157 17.0359 12.0569C17.8845 12.6176 18.5917 12.4775 18.5917 12.4775H21.562C21.562 12.4775 23.1178 12.3373 22.4106 11.2157C22.4106 11.0755 21.9863 10.2343 20.1476 8.69216C18.3088 7.0098 18.4503 7.29019 20.8548 4.20588C22.2692 2.38333 22.835 1.26176 22.6935 0.700978C22.5521 0.28039 21.562 0.42059 21.562 0.42059H18.1674C18.1674 0.42059 17.8845 0.420588 17.7431 0.560784C17.6016 0.70098 17.4602 0.981371 17.4602 0.981371C17.4602 0.981371 16.8944 2.38333 16.1872 3.6451C14.6313 6.16863 14.0656 6.30882 13.7827 6.16863C13.2169 5.74804 13.3584 4.62647 13.3584 3.92549C13.3584 1.40196 13.7827 0.420589 12.6512 0.140197C12.2268 1.06543e-06 11.944 -2.13922e-06 11.0953 -2.13922e-06C9.82233 -2.13922e-06 8.83224 -1.06543e-06 8.26647 0.280391C7.84215 0.420587 7.55927 0.841177 7.70071 0.841177C7.9836 0.841177 8.40792 0.98137 8.6908 1.40196C8.97368 1.82255 8.97368 2.94412 8.97368 2.94412C8.97368 2.94412 9.11513 5.88824 8.54936 6.16863C8.12503 6.44902 7.41783 5.88824 6.14485 3.6451C5.43764 2.52353 4.87188 1.12157 4.87188 1.12157C4.87188 1.12157 4.73044 0.841174 4.589 0.700978C4.30611 0.560782 4.02323 0.560784 4.02323 0.560784H0.770071C0.770071 0.560784 0.345746 0.560785 0.0628629 0.841177C-0.0785787 0.981374 0.0628629 1.40196 0.0628629 1.40196C0.0628629 1.40196 2.60881 7.2902 5.43764 10.2343C8.12503 12.7578 11.0953 12.4775 11.0953 12.4775Z" transform="translate(6.78613 14.4898)" fill="white"/></svg>',
            ],
            [
                'example'     => 'https://workspace.slack.com/',
                'placeholder' => __('Slack', 'chaty'),
                'slug'        => 'Slack',
                'title'       => 'Slack',
                'color'       => '#3f0e40',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#3f0e40"/>
                  <g id="Group_521" data-name="Group 521" transform="translate(3.719 3.719)">
                    <path class="slack-path" data-name="Path 10688" d="M24,23.046,18.767,7.182a1.994,1.994,0,1,1,3.788-1.25l5.237,15.86A1.995,1.995,0,1,1,24,23.046Zm0,0" transform="translate(-3.511)" fill="#ffc305"/>
                    <path class="slack-path" data-name="Path 10689" d="M13.387,26.487,8.15,10.627a1.995,1.995,0,1,1,3.788-1.253l5.237,15.86a1.995,1.995,0,1,1-3.788,1.253Zm0,0" transform="translate(-0.868 -0.857)" fill="#7daf93"/>
                    <path class="slack-path" data-name="Path 10690" d="M8.1,26.645a2,2,0,0,1,1.27-2.52l15.863-5.24a2,2,0,1,1,1.25,3.79l-15.86,5.237A2,2,0,0,1,8.1,26.645Zm0,0" transform="translate(-0.857 -3.541)" fill="#e1325a"/>
                    <path class="slack-path" data-name="Path 10691" d="M12.633,24.551l3.791-1.25,1.25,3.791-3.791,1.25Zm0,0" transform="translate(-2.009 -4.665)" fill="#1b444f"/>
                    <path class="slack-path" data-name="Path 10692" d="M23.23,21.051l3.79-1.25,1.25,3.791-3.791,1.25Zm0,0" transform="translate(-4.647 -3.794)" fill="#e64b55"/>
                    <path class="slack-path" data-name="Path 10693" d="M4.662,16.028a2,2,0,0,1,1.27-2.52l15.86-5.237a1.995,1.995,0,1,1,1.253,3.788L7.185,17.3A2,2,0,0,1,4.662,16.028Zm0,0" transform="translate(0 -0.898)" fill="#91cdff"/>
                    <path class="slack-path" data-name="Path 10694" d="M9.133,13.953,12.92,12.7l1.253,3.788-3.791,1.253Zm0,0" transform="translate(-1.138 -2.027)" fill="#51946f"/>
                    <path class="slack-path" data-name="Path 10695" d="M19.73,10.456,23.518,9.2l1.253,3.791-3.791,1.25Zm0,0" transform="translate(-3.776 -1.155)" fill="#82962d"/>
                  </g></svg>',
            ],
            [
                'example'     => 'https://discord.gg/abcde',
                'placeholder' => __('Discord', 'chaty'),
                'slug'        => 'Discord',
                'title'       => 'Discord',
                'color'       => '#5865F2',
                'svg'         => '<svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="24" cy="24" r="24" fill="#5865F2"/><path d="M32.3303 16.2278C30.7767 15.5009 29.1156 14.9727 27.3789 14.6719C27.1656 15.0575 26.9164 15.5761 26.7446 15.9887C24.8985 15.7111 23.0693 15.7111 21.2572 15.9887C21.0854 15.5761 20.8306 15.0575 20.6154 14.6719C18.8768 14.9727 17.2138 15.5029 15.6602 16.2317C12.5266 20.9669 11.6772 25.5845 12.1019 30.1365C14.1803 31.6885 16.1944 32.6313 18.1746 33.2483C18.6635 32.5754 19.0995 31.8601 19.4752 31.1063C18.7598 30.8344 18.0745 30.499 17.4271 30.1095C17.5988 29.9822 17.7669 29.8492 17.9292 29.7123C21.8782 31.5594 26.1689 31.5594 30.0707 29.7123C30.235 29.8492 30.403 29.9822 30.5728 30.1095C29.9235 30.5009 29.2364 30.8363 28.521 31.1082C28.8966 31.8601 29.3308 32.5774 29.8216 33.2502C31.8036 32.6333 33.8197 31.6905 35.898 30.1365C36.3964 24.8595 35.0467 20.2843 32.3303 16.2278ZM20.0132 27.337C18.8277 27.337 17.8556 26.2303 17.8556 24.8826C17.8556 23.535 18.807 22.4264 20.0132 22.4264C21.2194 22.4264 22.1916 23.533 22.1708 24.8826C22.1727 26.2303 21.2194 27.337 20.0132 27.337ZM27.9867 27.337C26.8013 27.337 25.8291 26.2303 25.8291 24.8826C25.8291 23.535 26.7805 22.4264 27.9867 22.4264C29.193 22.4264 30.1651 23.533 30.1444 24.8826C30.1444 26.2303 29.193 27.337 27.9867 27.337Z" fill="white"/></svg>',
            ],
            [
                'example'     => 'https://teams.microsoft.com/join/abcde',
                'placeholder' => __('Microsoft Teams', 'chaty'),
                'slug'        => 'Microsoft_Teams',
                'title'       => 'Microsoft Teams',
                'color'       => '#4B53BC',
                'svg'         => '<svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle class="color-element" cx="24" cy="24" r="24" fill="#4B53BC"/> <g clip-path="url(#clip0_3945_17159)"> <path d="M28.9361 21H35.5782C36.2057 21 36.7144 21.5104 36.7144 22.14V28.2102C36.7144 30.5242 34.8448 32.4 32.5385 32.4H32.5188C30.2125 32.4003 28.3426 30.5248 28.3423 28.2108C28.3423 28.2106 28.3423 28.2104 28.3423 28.2102V21.5958C28.3423 21.2667 28.6082 21 28.9361 21Z" fill="#F2F2F2"/> <path d="M33.4254 19.8004C34.9116 19.8004 36.1164 18.5916 36.1164 17.1004C36.1164 15.6092 34.9116 14.4004 33.4254 14.4004C31.9392 14.4004 30.7344 15.6092 30.7344 17.1004C30.7344 18.5916 31.9392 19.8004 33.4254 19.8004Z" fill="#F2F2F2"/> <path d="M25.0531 19.8C27.1998 19.8 28.9401 18.0539 28.9401 15.9C28.9401 13.7461 27.1998 12 25.0531 12C22.9063 12 21.166 13.7461 21.166 15.9C21.166 18.0539 22.9063 19.8 25.0531 19.8Z" fill="white"/> <path d="M30.2362 21H19.2723C18.6523 21.0154 18.1618 21.5317 18.1762 22.1538V29.0772C18.0896 32.8105 21.0334 35.9086 24.7543 36C28.4751 35.9086 31.4189 32.8105 31.3323 29.0772V22.1538C31.3467 21.5317 30.8562 21.0154 30.2362 21Z" fill="white"/> <path opacity="0.1" d="M25.3522 21V30.702C25.3492 31.1469 25.0805 31.5466 24.6705 31.716C24.5399 31.7714 24.3996 31.8 24.2578 31.8H18.7023C18.6246 31.602 18.5528 31.404 18.493 31.2C18.2837 30.5115 18.1769 29.7958 18.1761 29.076V22.152C18.1617 21.5309 18.6514 21.0154 19.2704 21H25.3522Z" fill="#D5D5D5"/> <path opacity="0.2" d="M24.7542 21V31.302C24.7542 31.4442 24.7257 31.585 24.6705 31.716C24.5016 32.1274 24.1033 32.397 23.6598 32.4H18.9834C18.8817 32.202 18.7861 32.004 18.7023 31.8C18.6186 31.596 18.5528 31.404 18.493 31.2C18.2837 30.5115 18.1769 29.7958 18.1761 29.076V22.152C18.1617 21.5309 18.6514 21.0154 19.2704 21H24.7542Z" fill="#D5D5D5"/> <path opacity="0.2" d="M24.7542 21V30.102C24.7496 30.7065 24.2623 31.1954 23.6598 31.2H18.493C18.2837 30.5115 18.1769 29.7958 18.1761 29.076V22.152C18.1617 21.5309 18.6514 21.0154 19.2704 21H24.7542Z" fill="#D5D5D5"/> <path opacity="0.2" d="M24.1562 21V30.102C24.1516 30.7065 23.6643 31.1954 23.0618 31.2H18.493C18.2837 30.5115 18.1769 29.7958 18.1761 29.076V22.152C18.1617 21.5309 18.6514 21.0154 19.2704 21H24.1562Z" fill="#D5D5D5"/> <path opacity="0.1" d="M25.3523 17.8988V19.7888C25.2507 19.7948 25.155 19.8008 25.0533 19.8008C24.9517 19.8008 24.856 19.7948 24.7543 19.7888C24.5525 19.7753 24.3523 19.7432 24.1563 19.6928C22.9454 19.405 21.9449 18.5529 21.4653 17.4008C21.3828 17.2073 21.3187 17.0064 21.2739 16.8008H24.258C24.8614 16.8031 25.35 17.2933 25.3523 17.8988Z" fill="#959595"/> <path d="M24.7544 18.4984V19.7884C24.5525 19.7749 24.3523 19.7428 24.1564 19.6924C22.9454 19.4047 21.9449 18.5526 21.4653 17.4004H23.66C24.2635 17.4027 24.7521 17.8929 24.7544 18.4984Z" fill="#EDEDED"/> <path opacity="0.2" d="M24.1564 18.4984V19.6924C22.9454 19.4047 21.9449 18.5526 21.4653 17.4004H23.062C23.6655 17.4027 24.1541 17.8929 24.1564 18.4984Z" fill="black"/> <path d="M12.0961 17.4004H23.06C23.6654 17.4004 24.1561 17.8928 24.1561 18.5002V29.5006C24.1561 30.108 23.6654 30.6004 23.06 30.6004H12.0961C11.4908 30.6004 11 30.108 11 29.5006V18.5002C11 17.8928 11.4908 17.4004 12.0961 17.4004Z" fill="#F2F2F2"/> <path d="M20.4629 21.5874H18.2712V27.5754H16.8749V21.5874H14.6934V20.4258H20.4629V21.5874Z" fill="#C4C4C4"/> </g> <defs> <clipPath id="clip0_3945_17159"> <rect width="25.7143" height="24" fill="white" transform="translate(11 12)"/> </clipPath> </defs> </svg>',
            ],
            [
                'example'     => 'https://www.example.com/contact',
                'placeholder' => __('Link', 'chaty'),
                'slug'        => 'Link',
                'title'       => 'Custom Link',
                'color'       => '#1E88E5',
                'help_title'  => 'How do I use this?',
                'help'        => 'Add a link to any page you want or a JavaScript code',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#1E88E5"/>
                            <mask id="path-2-outside-1" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(9.95154 16.0478)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(9.95154 16.0478)" fill="white" mask="url(#path-2-outside-1)"/>
                            <mask id="path-4-outside-2" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white" mask="url(#path-4-outside-2)"/></svg>',
            ],
            [
                'example'     => 'https://www.example.com/contact',
                'placeholder' => __('Link', 'chaty'),
                'slug'        => 'Custom_Link',
                'title'       => 'Custom Link',
                'color'       => '#8141FC',
                'help_title'  => 'How do I use this?',
                'help'        => 'Add a link to any page you want or a JavaScript code',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#8141FC"/>
                            <mask id="path-2-outside-1" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(9.95154 16.0478)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(9.95154 16.0478)" fill="white" mask="url(#path-2-outside-1)"/>
                            <mask id="path-4-outside-2" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white" mask="url(#path-4-outside-2)"/></svg>',
            ],
            [
                'example'     => 'https://www.example.com/contact',
                'placeholder' => __('Link', 'chaty'),
                'slug'        => 'Custom_Link_3',
                'title'       => 'Custom Link',
                'color'       => '#FF7539',
                'help_title'  => 'How do I use this?',
                'help'        => 'Add a link to any page you want or a JavaScript code',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#FF7539"/>
                            <mask id="path-2-outside-1" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(9.95154 16.0478)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(9.95154 16.0478)" fill="white" mask="url(#path-2-outside-1)"/>
                            <mask id="path-4-outside-2" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white" mask="url(#path-4-outside-2)"/></svg>',
            ],
            [
                'example'     => 'https://www.example.com/contact',
                'placeholder' => __('Link', 'chaty'),
                'slug'        => 'Custom_Link_4',
                'title'       => 'Custom Link',
                'color'       => '#2A9D8F',
                'help_title'  => 'How do I use this?',
                'help'        => 'Add a link to any page you want or a JavaScript code',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#2A9D8F"/>
                            <mask id="path-2-outside-1" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(9.95154 16.0478)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(9.95154 16.0478)" fill="white" mask="url(#path-2-outside-1)"/>
                            <mask id="path-4-outside-2" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white" mask="url(#path-4-outside-2)"/></svg>',
            ],
            [
                'example'     => 'https://www.example.com/contact',
                'placeholder' => __('Link', 'chaty'),
                'slug'        => 'Custom_Link_5',
                'title'       => 'Custom Link',
                'color'       => '#E9C46A',
                'help_title'  => 'How do I use this?',
                'help'        => 'Add a link to any page you want or a JavaScript code',
                'svg'         => '<svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg"><circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#E9C46A"/>
                            <mask id="path-2-outside-1" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(9.95154 16.0478)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(9.95154 16.0478)" fill="white" mask="url(#path-2-outside-1)"/>
                            <mask id="path-4-outside-2" maskUnits="userSpaceOnUse" x="-1" y="-1" width="13" height="14" fill="black">
                                <rect fill="white" x="-1" y="-1" width="13" height="14"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z"/>
                            </mask>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.10658 1.73537C9.10658 1.73537 9.10658 1.73538 9.10659 1.73538L9.93879 2.58495C9.9388 2.58495 9.9388 2.58495 9.9388 2.58496C9.99645 2.64381 10.0508 2.70475 10.1019 2.76754C10.3002 3.0113 10.6804 3.07698 10.9003 2.85252C11.0424 2.70754 11.0721 2.4836 10.9533 2.31904C10.849 2.17452 10.7327 2.03614 10.6046 1.90532C10.6046 1.9053 10.6046 1.90529 10.6045 1.90528L9.77236 1.05572C9.77236 1.05572 9.77235 1.05572 9.77235 1.05572C8.39351 -0.351905 6.15792 -0.351905 4.77907 1.05571C4.77907 1.05572 4.77907 1.05572 4.77906 1.05572L1.03414 4.87877C1.03413 4.87878 1.03413 4.87878 1.03413 4.87878C-0.344706 6.2864 -0.34471 8.56858 1.03412 9.9762C1.03413 9.97621 1.03414 9.97622 1.03415 9.97623L1.86633 10.8258C1.86634 10.8258 1.86635 10.8258 1.86636 10.8258C3.24521 12.2334 5.48072 12.2334 6.85962 10.8258C6.85963 10.8258 6.85964 10.8258 6.85964 10.8258L9.28893 8.34581C9.47006 8.1609 9.47006 7.86509 9.28893 7.68018C9.10243 7.48979 8.79591 7.48979 8.60942 7.68018L6.19386 10.1461C6.19386 10.1461 6.19386 10.1461 6.19386 10.1461C5.1827 11.1784 3.54326 11.1784 2.53215 10.1461C2.53213 10.1461 2.53211 10.1461 2.53209 10.1461L1.69991 9.29657C1.69991 9.29657 1.6999 9.29656 1.6999 9.29655C0.688737 8.2643 0.688739 6.59069 1.6999 5.55844C1.6999 5.55843 1.69991 5.55843 1.69991 5.55843L5.44484 1.73538C5.44484 1.73538 5.44484 1.73537 5.44484 1.73537C6.45601 0.703119 8.09541 0.703118 9.10658 1.73537Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white"/>
                            <path d="M5.44484 1.73538L5.23053 1.52545L5.44484 1.73538ZM5.44484 1.73537L5.23053 1.52544L5.44484 1.73537ZM1.6999 5.55844L1.48559 5.3485L1.6999 5.55844ZM1.69991 5.55843L1.91422 5.76836L1.69991 5.55843ZM1.69991 9.29657L1.91422 9.08664L1.69991 9.29657ZM1.6999 9.29655L1.91421 9.08662L1.6999 9.29655ZM2.53215 10.1461L2.31784 10.3561L2.53215 10.1461ZM2.53209 10.1461L2.31778 10.356L2.53209 10.1461ZM6.19386 10.1461L5.97955 9.93618L6.19386 10.1461ZM6.19386 10.1461L6.40817 10.356L6.19386 10.1461ZM8.60942 7.68018L8.82373 7.89011L8.60942 7.68018ZM9.28893 8.34581L9.07462 8.13588L9.28893 8.34581ZM6.85962 10.8258L6.64532 10.6158L6.85962 10.8258ZM6.85964 10.8258L7.07395 11.0357L6.85964 10.8258ZM1.86633 10.8258L2.08064 10.6158L1.86633 10.8258ZM1.86636 10.8258L2.08067 10.6159L1.86636 10.8258ZM1.03412 9.9762L1.24843 9.76628L1.03412 9.9762ZM1.03415 9.97623L0.819841 10.1862L1.03415 9.97623ZM1.03414 4.87877L0.819827 4.66884L1.03414 4.87877ZM1.03413 4.87878L1.24844 5.08871L1.03413 4.87878ZM4.77907 1.05571L4.99338 1.26564L4.77907 1.05571ZM4.77906 1.05572L4.99338 1.26565L4.77906 1.05572ZM9.77236 1.05572L9.55805 1.26565L9.77236 1.05572ZM9.77235 1.05572L9.98666 0.845785L9.77235 1.05572ZM10.6046 1.90532L10.8189 1.6954L10.6046 1.90532ZM10.6045 1.90528L10.8189 1.69535L10.6045 1.90528ZM10.9533 2.31904L10.7101 2.49464L10.9533 2.31904ZM10.1019 2.76754L9.86916 2.95685L10.1019 2.76754ZM9.10659 1.73538L9.3209 1.52545L9.10659 1.73538ZM9.10658 1.73537L8.89227 1.9453L9.10658 1.73537ZM9.93879 2.58495L10.1531 2.37502L9.93879 2.58495ZM9.9388 2.58496L10.1531 2.37503L9.9388 2.58496ZM10.1531 2.37502L9.3209 1.52545L8.89228 1.94531L9.72448 2.79488L10.1531 2.37502ZM10.3346 2.57823C10.2777 2.50832 10.2172 2.4405 10.1531 2.37503L9.72449 2.79488C9.77566 2.84713 9.82388 2.90119 9.86916 2.95685L10.3346 2.57823ZM11.1966 2.14344C11.0835 1.98684 10.9576 1.83698 10.8189 1.6954L10.3903 2.11524C10.5079 2.2353 10.6145 2.3622 10.7101 2.49464L11.1966 2.14344ZM10.8189 1.69535L9.98667 0.845789L9.55805 1.26565L10.3902 2.11521L10.8189 1.69535ZM9.98666 0.845785C8.49018 -0.681928 6.06124 -0.681928 4.56476 0.845784L4.99338 1.26564C6.25459 -0.0218819 8.29683 -0.0218814 9.55804 1.26565L9.98666 0.845785ZM4.56475 0.84579L0.819827 4.66884L1.24845 5.0887L4.99338 1.26565L4.56475 0.84579ZM0.819819 4.66885C-0.673269 6.1931 -0.673273 8.66187 0.819807 10.1861L1.24843 9.76628C-0.0161474 8.47529 -0.016144 6.37969 1.24844 5.08871L0.819819 4.66885ZM0.819841 10.1862L1.65203 11.0357L2.08064 10.6158L1.24846 9.7663L0.819841 10.1862ZM1.65205 11.0357C3.14854 12.5634 5.57739 12.5634 7.07393 11.0357L6.64532 10.6158C5.38405 11.9034 3.34188 11.9034 2.08067 10.6159L1.65205 11.0357ZM7.07395 11.0357L9.50324 8.55574L9.07462 8.13588L6.64533 10.6158L7.07395 11.0357ZM6.40817 10.356L8.82373 7.89011L8.39511 7.47025L5.97955 9.93618L6.40817 10.356ZM2.31784 10.3561C3.44659 11.5084 5.27938 11.5084 6.40817 10.356L5.97955 9.93618C5.08603 10.8483 3.63993 10.8483 2.74646 9.93621L2.31784 10.3561ZM1.48561 9.50651L2.31778 10.356L2.7464 9.93615L1.91422 9.08664L1.48561 9.50651ZM1.48559 5.3485C0.360176 6.49739 0.360173 8.35759 1.48559 9.50648L1.91421 9.08662C1.0173 8.171 1.0173 6.68399 1.91421 5.76837L1.48559 5.3485ZM5.23053 1.52545L1.4856 5.3485L1.91422 5.76836L5.65915 1.94531L5.23053 1.52545ZM9.32089 1.52544C8.19208 0.373095 6.35934 0.373096 5.23053 1.52544L5.65915 1.9453C6.55268 1.03314 7.99874 1.03314 8.89227 1.9453L9.32089 1.52544ZM5.65915 1.94531C5.65915 1.94531 5.65915 1.94531 5.65915 1.9453L5.23053 1.52544C5.23053 1.52544 5.23053 1.52544 5.23053 1.52545L5.65915 1.94531ZM1.91421 5.76837C1.91421 5.76837 1.91422 5.76836 1.91422 5.76836L1.4856 5.3485C1.4856 5.3485 1.48559 5.3485 1.48559 5.3485L1.91421 5.76837ZM1.91422 9.08664C1.91422 9.08663 1.91421 9.08663 1.91421 9.08662L1.48559 9.50648C1.48559 9.50649 1.4856 9.5065 1.48561 9.50651L1.91422 9.08664ZM2.74646 9.93621C2.74644 9.93619 2.74642 9.93617 2.7464 9.93615L2.31778 10.356C2.3178 10.356 2.31782 10.356 2.31784 10.3561L2.74646 9.93621ZM5.97955 9.93618C5.97955 9.93618 5.97955 9.93618 5.97955 9.93618L6.40817 10.356C6.40817 10.356 6.40817 10.356 6.40817 10.356L5.97955 9.93618ZM9.50324 7.47025C9.1991 7.15977 8.69924 7.15977 8.39511 7.47025L8.82373 7.89011C8.89259 7.81981 9.00576 7.81981 9.07462 7.89011L9.50324 7.47025ZM9.50324 8.55574C9.79862 8.25419 9.79862 7.77179 9.50324 7.47025L9.07462 7.89011C9.1415 7.95838 9.1415 8.0676 9.07462 8.13588L9.50324 8.55574ZM7.07393 11.0357C7.07394 11.0357 7.07395 11.0357 7.07395 11.0357L6.64533 10.6158C6.64533 10.6158 6.64532 10.6158 6.64532 10.6158L7.07393 11.0357ZM1.65203 11.0357C1.65203 11.0357 1.65204 11.0357 1.65205 11.0357L2.08067 10.6159C2.08066 10.6158 2.08065 10.6158 2.08064 10.6158L1.65203 11.0357ZM0.819807 10.1861C0.819819 10.1861 0.81983 10.1862 0.819841 10.1862L1.24846 9.7663C1.24845 9.76629 1.24844 9.76628 1.24843 9.76628L0.819807 10.1861ZM0.819827 4.66884C0.819824 4.66884 0.819822 4.66885 0.819819 4.66885L1.24844 5.08871C1.24844 5.08871 1.24845 5.08871 1.24845 5.0887L0.819827 4.66884ZM4.56476 0.845784C4.56476 0.845786 4.56476 0.845788 4.56475 0.84579L4.99338 1.26565C4.99338 1.26565 4.99338 1.26565 4.99338 1.26564L4.56476 0.845784ZM9.98667 0.845789C9.98667 0.845788 9.98666 0.845787 9.98666 0.845785L9.55804 1.26565C9.55804 1.26565 9.55804 1.26565 9.55805 1.26565L9.98667 0.845789ZM10.8189 1.6954C10.8189 1.69538 10.8189 1.69536 10.8189 1.69535L10.3902 2.11521C10.3902 2.11522 10.3903 2.11523 10.3903 2.11524L10.8189 1.6954ZM11.1146 3.06246C11.3462 2.82606 11.411 2.44051 11.1966 2.14344L10.7101 2.49464C10.7332 2.52669 10.7385 2.58902 10.686 2.64258L11.1146 3.06246ZM9.86916 2.95685C10.1487 3.30046 10.7367 3.44829 11.1146 3.06246L10.686 2.64258C10.652 2.67732 10.6006 2.69693 10.531 2.68804C10.4586 2.67877 10.3842 2.63918 10.3346 2.57823L9.86916 2.95685ZM9.3209 1.52545C9.32089 1.52544 9.32089 1.52544 9.32089 1.52544L8.89227 1.9453C8.89227 1.9453 8.89227 1.94531 8.89228 1.94531L9.3209 1.52545ZM9.72448 2.79488C9.72448 2.79488 9.72448 2.79488 9.72449 2.79488L10.1531 2.37503C10.1531 2.37503 10.1531 2.37502 10.1531 2.37502L9.72448 2.79488Z" transform="translate(28.9286 22.8312) rotate(-180)" fill="white" mask="url(#path-4-outside-2)"/></svg>',
            ],
        ];

    }//end get_icons_list()


}//end class
