<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

/**
 *
 * CTA Box Widget .
 *
 */
class Bizino_CTA_Box extends Widget_Base{

    public function get_name(){
        return 'bizinoctabox';
    }

    public function get_title(){
        return __( 'CTA Box', 'bizino' );
    }

    public function get_icon(){
        return 'eicon-code';
    }

    public function get_categories(){
        return ['bizino'];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'counter_section',
            [
                'label' => __('CTA Box', 'bizino'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'cta_box_style',
            [
                'label'     => __( 'CTA Box Style', 'bizino' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '1',
                'options'   => [
                    '1' => __( 'Style One', 'bizino' ),
                    '2' => __( 'Style Two', 'bizino' ),
                ],
            ]
        );

        $this->add_control(
            'cta_box_image',
            [
                'label'         => __( 'CTA image', 'bizino' ),
                'type'          => Controls_Manager::MEDIA,
                'default'       => [
                    'url'   => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'cta_box_title', [
                'label'         => __('CTA Box Title', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Business Consultin', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $this->add_control(
            'cta_box_subtitle', [
                'label'         => __( 'CTA Box Subtitle', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Market evolve comping supply chains without virtual resourc. ', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $this->add_control(
            'button_text', [
                'label'         => __( 'Button Text', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Read More', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $this->add_control(
            'details_url', [
                'label'         => __( 'Button Text Url?', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( '#', 'bizino' ),
                'label_block'   => true,
            ]
        );
        

        $this->end_controls_section();


        $this->start_controls_section(
            'title_styling',
            [
                'label'     => __( 'Title Styling', 'bizino' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta_title_color',
            [
                'label'     => __( 'Title Color', 'bizino' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-box1 .cta-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'cta_title_typography',
                'label'     => __('Title Typography', 'bizino'),
                'selector'  => '{{WRAPPER}} .cta-box1 .cta-title'
            ]
        );

        $this->add_responsive_control(
            'cta_title_margin',
            [
                'label'         => __('Title Margin', 'bizino'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .cta-box1 .cta-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'cta_title_padding',
            [
                'label'         => __('Title Padding', 'bizino'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .cta-box1 .cta-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'subtitle_styling',
            [
                'label'     => __( 'SubTitle Styling', 'bizino' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta_subtitle_color',
            [
                'label'     => __( 'SubTitle Color', 'bizino' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-box1 .cta-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'cta_subtitle_typography',
                'label'     => __('SubTitle Typography', 'bizino'),
                'selector'  => '{{WRAPPER}} .cta-box1 .cta-text'
            ]
        );

        $this->add_responsive_control(
            'cta_subtitle_margin',
            [
                'label'         => __('SubTitle Margin', 'bizino'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .cta-box1 .cta-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'cta_subtitle_padding',
            [
                'label'         => __('SubTitle Padding', 'bizino'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em'],
                'selectors'     => [
                    '{{WRAPPER}} .cta-box1 .cta-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(){

        $settings = $this->get_settings_for_display();
        
        if( $settings['cta_box_style'] == '2' ){
            $class = "style-2";
            $icon_class = "cta-icon";
        }else{
            $class = "";
            $icon_class = "cta-img";
        }
        
        echo '<div class="cta-box1 '.$class.'">';
            if( ! empty( $settings['cta_box_image']['url'] ) ){
                echo '<div class="'.$icon_class.'">';
                    echo techbiz_img_tag( array(
                        'url'   => esc_url( $settings['cta_box_image']['url'] ),
                    ) );
                echo '</div>';
            }
            if( ! empty( $settings['cta_box_title'] ) ){
                echo '<h3 class="cta-title"><a href="'.esc_url( $settings['details_url'] ).'" class="text-inherit">'.esc_html( $settings['cta_box_title'] ).'</a></h3>';
            }
            if( ! empty( $settings['cta_box_subtitle'] ) ){
                echo '<p class="cta-text">'.esc_html( $settings['cta_box_subtitle'] ).'</p>';
            }
            if( ! empty( $settings['button_text'] ) ){
                echo '<a href="'.esc_url( $settings['details_url'] ).'" class="vs-btn style7">'.esc_html( $settings['button_text'] ).'</a>';
            }
        echo '</div>';
    }
}

Plugin::instance()->widgets_manager->register(new Bizino_CTA_Box());